@extends('layouts.admin')

@section('content')
<div class="roles-management">
    <div class="dashboard-header">
        <h1>Create New Role</h1>
        <p>Define a new role and assign permissions</p>
    </div>

    <div class="dashboard-card">
        <div class="dashboard-card-header">
            <h3>Role Details</h3>
        </div>
        <div class="dashboard-card-body">
            <form action="{{ route('admin.roles.store') }}" method="POST">
                @csrf
                <div class="form-group">
                    <label for="name">Role Name</label>
                    <input type="text" class="form-control" id="name" name="name" value="{{ old('name') }}" required>
                    @error('name')
                        <div class="error-message">{{ $message }}</div>
                    @enderror
                    <div class="form-text">Enter a unique name for this role (e.g., "editor", "manager")</div>
                </div>

                <div class="form-group">
                    <label for="color">Display Color</label>
                    <div class="color-picker-wrapper">
                        <input type="color" id="color" name="color" class="color-picker-input" value="{{ old('color', '#4B8BFF') }}" required>
                        <input type="text" id="color-text" class="form-control color-text-input" value="{{ old('color', '#4B8BFF') }}" pattern="^#([A-Fa-f0-9]{6})$" required>
                    </div>
                    @error('color')
                        <div class="error-message">{{ $message }}</div>
                    @enderror
                    <div class="form-text">Choose a color to display this role with</div>
                </div>

                <div class="form-group">
                    <label for="order">Display Order</label>
                    <input type="number" class="form-control" id="order" name="order" value="{{ old('order', 0) }}" min="0">
                    @error('order')
                        <div class="error-message">{{ $message }}</div>
                    @enderror
                    <div class="form-text">Lower numbers appear first (e.g., 0, 1, 2, 3...)</div>
                </div>

                <div class="form-group">
                    <label>Permissions</label>
                    <div class="permission-groups">
                        <div class="permission-group">
                            @foreach($permissions as $permission)
                                <div class="form-check">
                                    <input type="checkbox" id="permission_{{ $permission->id }}" name="permissions[]" value="{{ $permission->id }}" {{ in_array($permission->id, old('permissions', [])) ? 'checked' : '' }}>
                                    <label for="permission_{{ $permission->id }}">{{ $permission->name }}</label>
                                </div>
                            @endforeach
                        </div>
                    </div>
                    @error('permissions')
                        <div class="error-message">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-group mt-4">
                    <button type="submit" class="btn btn-primary">Create Role</button>
                    <a href="{{ route('admin.roles') }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const colorPicker = document.getElementById('color');
    const colorText = document.getElementById('color-text');
    
    colorPicker.addEventListener('input', function() {
        colorText.value = this.value.toUpperCase();
    });
    
    colorText.addEventListener('input', function() {
        if (/^#[A-Fa-f0-9]{6}$/.test(this.value)) {
            colorPicker.value = this.value;
        }
    });
});
</script>
@endsection